import { MetadataRoute } from "next";

import { headers } from "next/headers";
import { getPagesService } from "../services/httpServices/SettingsServices";
import { getChefsSitemapService } from "../services/httpServices/ChefService";
import { getFoodSitemapService } from "../services/httpServices/FoodServices";

export default async function sitemap(): Promise<MetadataRoute.Sitemap> {
  const headersList = headers();
  const host = headersList.get("host");
  const [pageResult, chefs, foods] = await Promise.all([
    getPagesService(),
    getChefsSitemapService(),
    getFoodSitemapService(),
  ]);

  const pagesMap: MetadataRoute.Sitemap = pageResult.map((item) => ({
    url: `https://${host}/${item.slug}/`,

    changeFrequency: "monthly",
    priority: 1,
  }));
  const ChefMap: MetadataRoute.Sitemap = chefs.branches.map((item) => ({
    url: `https://${host}/chef/${item.id}/`,
    changeFrequency: "weekly",
    priority: 1,
  }));
  const foodMap: MetadataRoute.Sitemap = foods.products.map((item) => ({
    url: `https://${host}/product/${item.id}/${item.title.replaceAll(" ", "-")}`,
    changeFrequency: "weekly",
    priority: 1,
  }));

  return [...pagesMap, ...ChefMap, ...foodMap];
}
