import React from "react";
import { Modal } from "../Modal";
import Button from "../Button";

interface Props {
  open: boolean;
  onClose: () => void;
  onConfirm: () => void;
  isLoading?: boolean;
}

function ActiveOrderModal({ open, onClose, onConfirm, isLoading = false }: Props) {
  return (
    <Modal
      open={open}
      onClose={onClose}
      title="سفارش فعال موجود"
      wrapperClassName="max-w-md w-full"
    >
      <div className="flex flex-col gap-6">
        <p className="text-h4 text-center">
          شما سبد خرید باز دیگری دارید. آیا می‌خواهید سفارش فعال قبلی را حذف کنید؟
        </p>
        
        <div className="flex gap-4 mt-6 justify-center">
          <Button
            onClick={onClose}
            intent="outline"
            className="px-6 py-3"
            disabled={isLoading}
          >
            انصراف
          </Button>
          <Button
            onClick={onConfirm}
            intent="primary"
            className="px-6 py-3"
            isLoading={isLoading}
            disabled={isLoading}
          >
            حذف سفارش قبلی
          </Button>
        </div>
      </div>
    </Modal>
  );
}

export default ActiveOrderModal;