import React, { useEffect, useState } from "react";

import Select, { CSSObjectWithLabel } from "react-select";
import moment from "jalali-moment";
import { MONTHS } from "@/src/constants/Dates";
import persianDate from "@/src/utils/persianDate";
import { BirthDay } from "@/src/types/auth";

const CurrentYear = persianDate.getYear();

const days = new Array(31).fill(0).map((e, i) => ({
  value: i + 1,
  label: i + 1,
}));

interface Props {
  title?: string;
  onMountChanged: (mount: number) => void;
  onDayChanged: (day: number) => void;
  onYearChanged: (year: number) => void;
  value: BirthDay;
  startDate?: Date;
  endDate?: Date;
  fullwidth?: boolean;
}
const styles = {
  dropdownIndicator: (base: CSSObjectWithLabel) => ({
    ...base,
    padding: "0",
    color: "#000000",
  }),
  indicatorSeparator: () => ({
    display: "none",
  }),
  control: (base: CSSObjectWithLabel, state: any) => ({
    ...base,

    minWidth: "60px",
    width: " 100%",
    fontSize: "12px",
    borderColor: state.isFocused ? "#00000033" : "#00000033",
  }),
  singleValue: (base: CSSObjectWithLabel) => ({
    ...base,
  }),
  menu: (base: CSSObjectWithLabel) => ({
    ...base,
    width: " max-content",

    color: "black",
  }),
  option: (base: CSSObjectWithLabel, state: any) => ({
    ...base,
    color: state.isSelected ? "#0a0aa8" : "#000000",
    backgroundColor: state.isFocused ? "#717171" : "",

    ":focus": {
      ...base[":focus"],
      backgroundColor: "#717171",
    },
    ":hover": {
      ...base[":hover"],
      backgroundColor: "#717171",
    },
  }),
};
const years = new Array(90).fill(0).map((year, i) => ({
  value: CurrentYear - i,
  label: CurrentYear - i,
}));
function DatePicker({
  title,
  onDayChanged,
  onMountChanged,
  onYearChanged,
  value,
  endDate,
  startDate,
  fullwidth = false,
}: Props) {
  const [values, setValues] = useState({
    years,
    months: MONTHS,
    days,
  });
  const rangeHandler = () => {
    if (startDate) {
      const jStartDate = moment(startDate).locale("fa");

      setValues((prevState) => ({
        days: prevState.days.filter(
          (day) => day.value >= jStartDate.get("date")
        ),
        months: prevState.months.filter(
          (month) => month.value >= jStartDate.get("month") + 1
        ),
        years: prevState.years.filter(
          (year) => year.value >= jStartDate.get("year")
        ),
      }));
    }
    if (endDate) {
      const jEndDate = moment(endDate).locale("fa");

      setValues((prevState) => ({
        days: prevState.days.filter((day) => day.value <= jEndDate.get("date")),
        months: prevState.months.filter(
          (month) => month.value <= jEndDate.get("month") + 1
        ),
        years: prevState.years.filter(
          (year) => year.value <= jEndDate.get("year")
        ),
      }));
    }
  };
  useEffect(() => {
    if (startDate || endDate) rangeHandler();
  }, []);
  return (
    <div className="  flex w-full max-w-sm flex-col gap-3 ">
      {title && <p className=" text-h4  ">{title}</p>}
      <div
        className={`flex w-full items-center gap-1  ${
          fullwidth && "justify-between"
        }`}
      >
        <Select
          name="mount"
          isClearable={false}
          placeholder="روز"
          options={values.days}
          styles={styles}
          isMulti={false}
          onChange={(selected) => onDayChanged(selected?.value ?? 0)}
          value={values.days.find((item) => item.value === value.day)}
        />{" "}
        <Select
          name="mount"
          isClearable={false}
          placeholder="ماه"
          styles={{
            ...styles,
            control: (base: CSSObjectWithLabel, state) => ({
              ...base,
              ...styles.control,
              color: "#000000",
              width: " 100%",
              minWidth: "100px",
              fontSize: "12px",
              borderColor: state.isFocused ? "#00000033" : "#00000033",
            }),
          }}
          isMulti={false}
          options={values.months}
          onChange={(selected) => onMountChanged(selected?.value ?? 0)}
          value={values.months.find((item) => item.value === value.month)}
        />{" "}
        <Select
          name="mount"
          isClearable={false}
          placeholder="سال"
          options={values.years}
          isMulti={false}
          styles={styles}
          onChange={(selected) => onYearChanged(selected?.value ?? 0)}
          value={values.years.find((item) => item.value === value.year)}
        />
      </div>
    </div>
  );
}

export default DatePicker;
