"use client";

import React, { useMemo } from "react";
import { useSearchParams } from "next/navigation";
import { Modal } from "@/src/components/Modal";
import Login from "@/src/containers/Auth/Login";
import VerifyCode from "@/src/containers/Auth/VerfyCode";

interface LoginModalProps {
  open: boolean;
  onClose: VoidFunction;
}

export default function LoginModal({ open, onClose }: LoginModalProps) {
  const searchParams = useSearchParams();
  const step = searchParams.get("step") ?? "login";

  const content = useMemo(() => {
    switch (step) {
      case "login":
        return <Login />;
      case "verify":
        return <VerifyCode />;
      default:
        return <Login />;
    }
  }, [step]);

  return (
    <Modal
      open={open}
      onClose={onClose}
      title={step === "login" ? "ورود یا ثبت نام" : "تایید شماره"}
      inlineClassName="w-[400px]" // 👈 Set fixed width for modal content
    >
      {content}
    </Modal>
  );
}
