import React from "react";

interface Props {
  total: number; // e.g. 60000
  minOrder: number; // e.g. 50000
}

const OrderProgress: React.FC<Props> = ({ total, minOrder }) => {
  const remaining = Math.max(minOrder - total, 0);
  const percent = Math.min((total / minOrder) * 100, 100);

  return (
    <div className="w-full px-2 my-12">
      <div className="text-sm mb-1 flex text-h5 justify-between text-black/70">
        <span>
          {remaining > 0
            ? `${remaining.toLocaleString()} تومان مانده تا حداقل خرید`
            : "حداقل خرید انجام شد"}
        </span>
         <span>{minOrder.toLocaleString()} تومان</span>
      </div>

      <div className="h-4 w-full rounded-full bg-gray-200">
        <div
          className="bg-primary h-full rounded-full transition-all duration-300"
          style={{ width: `${percent}%` }}
        />
      </div>
    </div>
  );
};

export default OrderProgress;
