import React, { useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Thumbs } from "swiper/modules";
import Image from "next/image";
import { type Swiper as SwiperRef } from "swiper";
import { File } from "@/src/types/general";
import "swiper/css/thumbs";

interface Props {
  gallery: File[];

  image: string;
}
function ProductTumbSlider({ gallery, image }: Props) {
  const [thumbsSwiper, setThumbsSwiper] = useState<SwiperRef | null>(null);
  return (
    <div className="flex flex-col gap-8 ">
      <Swiper
        modules={[Thumbs]}
        thumbs={{
          swiper: thumbsSwiper && !thumbsSwiper.destroyed ? thumbsSwiper : null,
        }}
        slidesPerView={1}
        className="size-full"
      >
        <SwiperSlide>
          <div className=" h-[300px] w-full overflow-hidden rounded-half lg:size-[300px]  ">
            <Image
              src={image}
              alt="test"
              className="size-full object-contain"
              width={300}
              height={300}
            />
          </div>
        </SwiperSlide>
        {gallery.map((item) => (
          <SwiperSlide key={item.id}>
            <div className=" h-[300px] w-full overflow-hidden rounded-half object-contain lg:size-[300px]  ">
              <Image
                src={item?.path ?? ""}
                alt="test"
                className="size-full object-contain"
                width={300}
                height={300}
              />
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
      <Swiper
        modules={[Thumbs]}
        breakpoints={{
          240: {
            slidesPerView: 5,
          },

          540: {
            slidesPerView: 3,
          },
          670: {
            slidesPerView: 4,
          },
          890: {
            slidesPerView: 4,
          },
          1280: {
            slidesPerView: 4,
          },
        }}
        slideToClickedSlide
        spaceBetween={20}
        watchSlidesProgress
        onSwiper={(Swipper) => setThumbsSwiper(Swipper)}
        className="h-25 w-full"
      >
        <SwiperSlide className="size-full  overflow-hidden rounded-half ">
          <Image
            src={image}
            alt="test"
            width={50}
            height={50}
            className={`size-25  `}
          />
        </SwiperSlide>
        {gallery.map((item) => (
          <SwiperSlide
            className="size-full overflow-hidden rounded-half "
            key={item.id}
          >
            <Image
              src={item?.path ?? ""}
              alt="test"
              width={50}
              height={50}
              className={`size-25  `}
            />
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}

export { ProductTumbSlider };
