import React from "react";
import { Controller, useFormContext } from "react-hook-form";

import DatePicker from "../Datepicker";

interface Props {
  name: string;
  title?: string;
  startDate?: Date;
  endDate?: Date;
  fullwidth?: boolean;
}
export default function RHFDatePicker({
  name,
  title,
  endDate,
  startDate,
  fullwidth = false,
}: Props) {
  const { control } = useFormContext();

  return (
    <Controller
      name={name}
      control={control}
      render={({ field }) => (
        <>
          <DatePicker
            fullwidth={fullwidth}
            endDate={endDate}
            startDate={startDate}
            value={field.value}
            onDayChanged={(day) =>
              field.onChange({
                ...field.value,
                day,
              })
            }
            onMountChanged={(month) =>
              field.onChange({
                ...field.value,
                month,
              })
            }
            onYearChanged={(year) =>
              field.onChange({
                ...field.value,
                year,
              })
            }
            title={title}
          />
        </>
      )}
    />
  );
}
