import { useCopyToClipboard } from "@uidotdev/usehooks";
import { CopySuccess, DocumentCopy } from "iconsax-react";
import React from "react";

function Share() {
  const [copiedText, copyToClipboard] = useCopyToClipboard();

  return (
    <div className="flex flex-col items-center justify-center gap-2">
      <p className="text-h5">
        این غذا را با دوستان خوش خوراک خود به اشتراک بگذارید.
      </p>
      <button
        onClick={() => copyToClipboard(window.location.href)}
        className="border-stroke-primary flex w-full items-center justify-center gap-1 rounded-base border py-1 text-white "
      >
        {copiedText ? (
          <>
            <CopySuccess fontSize={16} />
            کپی شد
          </>
        ) : (
          <>
            <DocumentCopy fontSize={16} />
            کپی کردن لینک
          </>
        )}
      </button>
    </div>
  );
}

export default Share;
