import { FormProvider, TextField } from "@/src/components/RHF";
import React, { useMemo } from "react";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as Yup from "yup";
import Button from "@/src/components/Button";
import { useCart } from "@/src/hooks";
import { useSnackbar } from "notistack";

interface FormFields {
  code?: string;
}

const defaultValues: FormFields = {
  code: "",
};
interface Props {
  onVerify: (code: string, price: number) => void;
}
function DiscountForm({ onVerify }: Props) {
  const addressSchema = useMemo(
    () =>
      Yup.object().shape({
        code: Yup.string(),
      }),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []
  );

  const methods = useForm<FormFields>({
    defaultValues,
    resolver: yupResolver(addressSchema),
    mode: "onSubmit",
  });

  const {
    handleSubmit,
    formState: { isValid, isSubmitting },
    reset,
  } = methods;

  const { enqueueSnackbar } = useSnackbar();
  const { CheckDiscount } = useCart();
  const onSubmit = handleSubmit(async (values) => {
    try {
      if (values.code) {
        const price = await CheckDiscount(values.code);
        enqueueSnackbar("کد تخفیف با موفقیت اعمال شد", {
          variant: "success",
        });
        reset();
        onVerify(values.code, price.discountPrice);
      }
    } catch (error) {
      console.log(error);
      enqueueSnackbar(error.message ?? " کد تخفیف معتبر نیست", {
        variant: "error",
      });
    }
  });

  return (
    <div className="flex w-full flex-col px-8 py-12 lg:w-auto lg:px-16">
      <FormProvider methods={methods} onSubmit={onSubmit}>
        <div className=" flex w-full flex-col gap-8 lg:flex-row lg:items-center">
          <TextField
            fullWidth
            placeholder="کد تخفیف را وارد کنید ..."
            label=""
            name="code"
          />
          <Button type="submit" isLoading={isSubmitting} disabled={!isValid}>
            بررسی
          </Button>
        </div>
      </FormProvider>
    </div>
  );
}

export default DiscountForm;
