import React from "react";

import NextImg from "@/src/components/NextImage";

interface Props {
  title: string;
  image: string;
}

function SliderItem({ image, title }: Props) {
  return (
    <div className="flex h-full  w-full items-center justify-center rounded-full">
      <NextImg
        alt={title}
        src={image}
        width={200}
        height={200}
        imgWrapperClassName="rounded-full overflow-hidden"
        imgClassName="w-full h-full"
      />
    </div>
  );
}

export default SliderItem;
