import React from "react";
import NextImg from "@/src/components/NextImage";

import { Location, Star } from "iconsax-react";

interface Props {
  logo: string;
  cover: string;
  title: string;
  ariaTitle: string;
  rate: number;
}

function BestChefCard({ ariaTitle, logo, rate, title, cover }: Props) {
  return (
    <div className=" flex h-max flex-col rounded-half  ">
      <div
        className="h-[142px] bg-chef bg-cover bg-center bg-no-repeat"
        style={{
          backgroundImage: `url(${cover})`,
        }}
      >
        <div className="flex size-full  items-end justify-between bg-chef  p-4">
          <NextImg
            imgWrapperClassName="rounded-half  overflow-hidden"
            imgClassName="h-auto"
            src={logo}
            width={40}
            height={40}
            alt={title}
          />

          {!!rate && (
            <div className="  flex items-center gap-2  text-white ">
              <Star size="17" color="#FFB800" variant="Bold" />
              <p className="text-h5">{rate}</p>
            </div>
          )}
        </div>
      </div>
      <div className="flex w-full flex-col gap-8   p-4  pb-8 shadow-chef  drop-shadow-chef">
        <p className="text-h3 font-bold">{title}</p>
        <div className="flex w-full  items-center  justify-between">
          <div className="flex  items-center  gap-2 text-black/60">
            <Location size={12} />
            <p className="text-h5">{ariaTitle}</p>
          </div>
        </div>
      </div>
    </div>
  );
}

export default BestChefCard;
