import React, { useRef } from "react";
import { Swiper, SwiperRef, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";
import { useCodeFoodsQuery } from "@/src/hooks/Queries";

import { useCart } from "@/src/hooks";
import ProductCard from "@/src/components/ProductCard";
import MiniProductCard from "@/src/components/MiniProductCard";
import { useRouter } from "next/navigation";

interface Props {
  title: string;
  type: "mini" | "big";
  code: string;
}
function FoodSlider({ title, type, code }: Props) {
  const sliderRef = useRef<SwiperRef>(null);

  const { data, isLoading } = useCodeFoodsQuery({
    code,
  });
  const { handleAddCard, handleRemoveCard } = useCart();

  const router = useRouter();

  return (
    <div className=" container relative w-full pb-20 lg:p-0  ">
      <div className="mb-12 flex w-auto max-w-max  items-center gap-4 whitespace-nowrap border-b-2 border-primary">
        <p className="pr-1 text-h2 font-bold ">{title}</p>
      </div>

      {!isLoading && (
        <Swiper
          ref={sliderRef}
          navigation={true}
          modules={[Navigation]}
          className="w-full"
          spaceBetween={20}
          // loop
          breakpoints={{
            240: {
              slidesPerView: 1.2,
              spaceBetween: 10,
            },

            540: {
              slidesPerView: 3,
              spaceBetween: 10,
            },
            670: {
              slidesPerView: type === "big" ? 3.5 : 5,
              spaceBetween: 20,
            },
            750: {
              slidesPerView: type === "big" ? 3.5 : 6,
              spaceBetween: 20,
            },
          }}
        >
          {data?.data.map((product) => (
            <SwiperSlide key={product.id}>
              {type === "mini" ? (
                <MiniProductCard
                  className="w-full "
                  onSelect={() =>
                    router.push(
                      `/product/${product.id}/${product.title.replaceAll(" ", "-").replaceAll("%", "درصد")}`
                    )
                  }
                  titleClassName=" max-w-[200px] xl:max-w-[150px]"
                  onAddCard={(variety) => handleAddCard(product, variety)}
                  onRemoveCard={(variety) => handleRemoveCard(variety)}
                  key={product.id}
                  image={product.image}
                  title={product.title}
                  available={false}
                  varieties={product.varieties.slice(0, 1)}
                />
              ) : (
                <ProductCard
                  isLoadingCart
                  className="w-full border-b-0"
                  onSelect={() =>
                    router.push(
                      `/product/${product.id}/${product.title.replaceAll(" ", "-").replaceAll("%", "درصد")}`
                    )
                  }
                  titleClassName=" max-w-[200px] xl:max-w-[150px]"
                  onAddCard={(variety) => handleAddCard(product, variety)}
                  onRemoveCard={(variety) => handleRemoveCard(variety)}
                  key={product.id}
                  Summary={product.Summary}
                  image={product.image}
                  title={product.title}
                  available={false}
                  varieties={product.varieties.slice(0, 1)}
                />
              )}
            </SwiperSlide>
          ))}
        </Swiper>
      )}
    </div>
  );
}

export default FoodSlider;
