import NextImg from "@/src/components/NextImage";
import { useSliderQuery } from "@/src/hooks/Queries";
import Link from "next/link";
import React from "react";
import { Autoplay } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

function HeroSlider() {
  const { data, isLoading } = useSliderQuery("home");

  if (!data || isLoading || data.length === 0) {
    return null;
  }

  return (
    <div className=" h-[130px] xs:h-[190px] w-full  rounded-1 px-8 pt-8 lg:h-[400px] lg:px-0 ">
      <Swiper
        speed={5000}
        spaceBetween={30}
        // autoplay={{
        //   delay: 5000,
        // }}
        // loop
        modules={[Autoplay]}
        className="size-full"
      >
        {data.map((item, index) => (
          <SwiperSlide
            className="w-full   overflow-hidden rounded-1"
            key={index}
          >
            <Link href={item.link}>
              <NextImg
                src={item.image}
                fill
                imgStyles={{
                  objectFit: "cover",
                }}
                alt={item.title}
                imgWrapperClassName="h-full "
              />
            </Link>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}

export { HeroSlider };
