"use client";

import React from "react";
import { ApiComponents } from "@/src/services/httpServices/SettingsServices/types";
import { HeroSlider } from "../HeroSlider";
import CategorySlider from "../CategorySlider";

import ComponentSelector from "../ComponentSelector";

interface Props {
  components: ApiComponents[];
}

function HomePageContents({ components }: Props) {



  return (
    <div className="lg:container">
      <div className="  flex w-full flex-col gap-20 pb-20">
        <HeroSlider />

        {process.env.NEXT_PUBLIC_SHOW_CATEGORY_HOMEPAGE === 'false' ?
          '' :
          <div className="pr-12">
            <CategorySlider />
          </div>
        }

        {components.map((component) => (
          <ComponentSelector
            key={component.code}
            data={component.extra}
            code={component.code}
            slug={component.name_component}
          />
        ))}
      </div>


    </div>
  );
}

export default HomePageContents;
