import React from "react";

import { useHomeItemsQuery } from "@/src/hooks/Queries";
import { ApiComponentExtraData } from "@/src/services/httpServices/SettingsServices/types";
import ChefSlider from "../BestChefSlider/ChefSlider";

interface Props {
  code: string;
  extraData: ApiComponentExtraData;
}
function ItemsSlider({ code, extraData }: Props) {
  const { data, isLoading } = useHomeItemsQuery({
    code,
  });
  return (
    <div className="container flex flex-col gap-20 px-10 lg:px-0">
      {!isLoading && data && (
        <ChefSlider
          link={extraData.link_more}
          chefs={data}
          title={extraData.title}
          buttonText={extraData.btn_text_more}
        />
      )}
    </div>
  );
}

export default ItemsSlider;
