import React from "react";

import NextImg from "@/src/components/NextImage";
import Link from "next/link";
import { ArrowLeft } from "iconsax-react";
import { useCodeFoodsQuery } from "@/src/hooks/Queries";

import Skeleton from "react-loading-skeleton";
import OfferSlider from "./OfferSlider";

interface Props {
  title: string;
  buttonText: string;
  bgColor: string;
  image: string;
  code: string;
}

function Offers({ buttonText, title, bgColor, image, code }: Props) {
  const { data, isLoading } = useCodeFoodsQuery({
    code,
  });
  return (
    <>
      {isLoading && <Skeleton className="h-80 w-full" />}

      {data && !isLoading && data.total !== 0 && (
        <div
          className="flex flex-col gap-20 p-12 lg:flex-row lg:rounded-1 "
          style={{
            backgroundColor: bgColor,
          }}
        >
          <div className="flex w-full  flex-row items-center justify-between gap-8  px-12 text-white lg:w-1/6 lg:flex-col lg:justify-center  ">
            <p className="text-body font-bold  lg:text-h2">{title}</p>
            <NextImg
              width={150}
              height={150}
              imgWrapperClassName="lg:block hidden"
              alt="tt"
              objectFit="contain"
              src={image}
            />
            <Link
              className="relative flex items-center  gap-4 text-h5 lg:text-body"
              href="/chefs"
            >
              {buttonText}
              <ArrowLeft className="z-10" color="#ffffff" variant="Broken" />
              <span className="absolute left-px  size-2 rounded-full bg-darkBlue "></span>
            </Link>
          </div>
          <div className="w-full  lg:w-5/6 ">
            <OfferSlider data={data} />
          </div>
        </div>
      )}
    </>
  );
}

export default Offers;
