import { getPageComponentsBySlugService } from "@/src/services/httpServices/SettingsServices";
import { cookies } from "next/headers";

import React from "react";
import HomePageContents from "./HomePageContents";

async function HomePage() {
  const cookieStore = cookies();
  const lat = cookieStore.get("lat")?.value || "";
  const lng = cookieStore.get("lng")?.value || "";

  const Components = await getPageComponentsBySlugService("home", { lat, lng });

  return <HomePageContents components={Components} />;
}

export default HomePage;
