import { menuItems } from "@/src/constants/MenuItems";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import Link from "next/link";
import React, { useMemo } from "react";

interface Props {
  onChefRegistration: VoidFunction;
}
function MenuItems({ onChefRegistration }: Props) {
  const { mode } = useSettingsStore((state) => state.settings);
  const filteredMenuItems = useMemo(
    () =>
      menuItems.filter((item) =>
        mode === "single" ? !item.multiVendorExclusive : item
      ),
    [mode]
  );
  return (
    <div className="flex gap-6 text-h3  font-bold">
      {filteredMenuItems.map((item) => (
        <Link href={item.link} key={item.title}>
          {item.title}
        </Link>
      ))}
      {mode === "multiVendor" && (
        <button onClick={onChefRegistration}>ثبت نام رستوران</button>
      )}
    </div>
  );
}

export default MenuItems;
