"use client";

import { useSettingsStore } from "@/src/providers/SettingsProvider";
import Image from "next/image";
import React from "react";

function Loader() {
  const { loader, title } = useSettingsStore((state) => state.settings);

  return (
    <div className="fixed inset-0 z-[500] flex h-screen w-full items-center justify-center bg-white">
      <div className="flex w-full max-w-xs flex-col items-center justify-center gap-12  rounded-half bg-white p-8  shadow-4">
        <Image src={loader} alt={title} width={150} height={42} quality={100} />
        <div className="flex   items-center justify-center space-x-2 ">
          <span className="sr-only">Loading...</span>
          <div className="size-3 animate-bounce rounded-full bg-primary [animation-delay:-0.3s]"></div>
          <div className="size-3 animate-bounce rounded-full bg-primary [animation-delay:-0.15s]"></div>
          <div className="size-3 animate-bounce rounded-full  bg-primary"></div>
        </div>
      </div>
    </div>
  );
}

export default Loader;
