import React from "react";
import Button from "@/src/components/Button";
import checkedImg from "@/public/assets/images/icons/close.svg";
import { Order } from "@/src/types/Cart";
import { AuthUser } from "@/src/types/auth";
import Image from "next/image";
import OrderDetailCard from "@/src/components/OrderDetailCard";
import { useSnackbar } from "notistack";
import { orderResultMode } from "@/src/types/general";

interface Props {
  order?: Order & { user: AuthUser; paymentCode: string };
  mode: orderResultMode;
}
function OrderError({ order, mode }: Props) {
  const { enqueueSnackbar } = useSnackbar();

  const handleFinishOrder = async () => {
    try {
      window.location.href = `${process.env.NEXT_PUBLIC_DOMAIN}/payment/pay_order?code=${order?.paymentCode}&has_wallet=true&gateway_id=1`;
    } catch (error) {
      console.log(error);
      enqueueSnackbar("خطا در ثبت اطلاعات", {
        variant: "error",
      });
    }
  };
  return (
    <div className="flex flex-col justify-center gap-12 lg:flex-row">
      <div className="flex w-full flex-col gap-12  lg:w-3/4">
        <div className="flex w-full flex-col items-center  justify-center gap-3 rounded-1 border border-black/20  px-12 py-20 text-center lg:gap-8">
          <Image src={checkedImg} width={55} height={55} alt="ss" />
          <p className="text-h5 font-bold lg:text-h3 ">
            برای جلو گیری از لغو سیستمی سفارش، دقایقی دیگر پرداخت را انجام دهید.
          </p>
          <p className="text-error-primary  text-h5 lg:text-h4">
            چناچه طی این فرآیند مبلغی از حساب شما کسر شده است طی 72 ساعت آینده
            به حساب شما باز خواهد گشت.
          </p>
        </div>
      </div>

      {mode === "order" && (
        <OrderDetailCard
          isLoading={false}
          pricing={order?.pricing}
          footer={
            <>
              <Button
                onClick={() => handleFinishOrder()}
                fullWidth
                intent="primary"
                className="py-2"
              >
                پرداخت
              </Button>
            </>
          }
        />
      )}
    </div>
  );
}

export default OrderError;
