import React from "react";
import { Post } from "@/src/types/Post";
import Link from "next/link";

interface Props {
  posts: Post[] | [];
}

function PostHeader({ posts }: Props) {
  return (
    <div className="grid h-[500px] w-full grid-cols-1 gap-10 lg:grid-cols-4">
      {posts.slice(0, 4).map((post, index) => (
        <Link
          href={`/post/${post.id}`}
          key={post.id}
          className={`group relative h-full overflow-hidden rounded-half bg-cover bg-center bg-no-repeat ${
            index === 0
              ? "col-span-1 row-span-1 lg:col-span-2 lg:row-span-2"
              : "col-span-1"
          }`}
        >
          <div
            className="absolute inset-0 scale-100 transition-transform duration-500 group-hover:scale-110"
            style={{
              backgroundImage: `url(${post.cover})`,
              backgroundSize: "cover",
              backgroundPosition: "center",
            }}
          ></div>
          <div className="absolute bottom-0 left-0 w-full bg-gradient-to-t from-black/80 to-transparent p-8 text-white">
            {post.title}
          </div>
        </Link>
      ))}
    </div>
  );
}

export default PostHeader;
