import { TextField, TextArea, Select } from "@/src/components/RHF";
import React, { useEffect } from "react";
import { useFormContext } from "react-hook-form";

import Button from "@/src/components/Button";
import { ArrowLeft2 } from "iconsax-react";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import { useAreasQuery, useChildAreasQuery } from "@/src/hooks/Queries";
import { AddressForm } from "@/src/types/Address";

interface Props {
  onShowMap: VoidFunction;
}
function AddressFormDetail({ onShowMap }: Props) {
  const { formState, watch, setValue } = useFormContext<AddressForm>();
  const { isSubmitting, isValid } = formState;
  const { forceMap } = useSettingsStore((state) => state.settings);
  const area = watch("area.parent");
  const { data: areasOptions } = useAreasQuery();
  const { data: childAreasOptions } = useChildAreasQuery(area?.value);
  useEffect(() => {
    setValue("area.child", null);
  }, [area]);
  return (
    <div className=" flex w-full flex-col gap-8">
      <div className="grid grid-cols-1   ">
        <TextField fullWidth type="text" name="title" label="عنوان آدرس*" />{" "}
      </div>
      {!forceMap && (
        <div className="grid grid-cols-2 gap-2 ">
          <Select
            placeholder="استان"
            label="استان"
            options={areasOptions}
            name="area.parent"
            fullWidth
          />
          {childAreasOptions && !!childAreasOptions?.length && (
            <Select
              disabled={!childAreasOptions || !childAreasOptions?.length}
              placeholder="منطقه"
              label="منطقه"
              options={childAreasOptions}
              name="area.child"
              fullWidth
            />
          )}
        </div>
      )}
      <div className="flex flex-col gap-1">
        <TextArea
          rows={5}
          fullWidth
          name="address"
          label="نشانی پستی"
        ></TextArea>

        {forceMap && (
          <>
            <p className="text-h5 text-[#B9B9B9]">
              آدرس بالا بر اساس موقعیت انتخابی شما وارد شده است.
            </p>
            <button
              type="button"
              onClick={() => onShowMap()}
              className="flex items-center text-h4   text-text-link"
            >
              اصلاح موقعیت مکانی روی نقشه
              <ArrowLeft2 size="22" color="#007AFF" />
            </button>
          </>
        )}
      </div>

      <div className="grid grid-cols-1 ">
        <TextField
          fullWidth
          type="text"
          name="phone"
          label="شماره تماس*"
          inputMode="decimal"
        />{" "}
      </div>
      <Button
        fullWidth
        type="submit"
        isLoading={isSubmitting}
        disabled={!isValid}
      >
        ثبت تغییرات
      </Button>
    </div>
  );
}

export default AddressFormDetail;
