import Button from "@/src/components/Button";
import dynamic from "next/dynamic";
import React, { useState } from "react";

const NeshanMapContainer = dynamic(
  () => import("@/src/components/NeshanMapContainer"),
  { ssr: false }
);

interface Props {
  onClick: (lat: string, lng: string) => void;
  onFinish: VoidFunction;
}

function AddressFormMap({ onClick, onFinish }: Props) {
  const [location, setLocation] = useState({ lat: "", lng: "" });

  const handleMapClick = (lat: string, lng: string) => {
    setLocation({ lat, lng });
    onClick(lat, lng);
  };

  return (
    <div className="flex flex-col gap-8">
      <p className="text-h4">موقعیت مکانی آدرس را مشخص کنید</p>

      <div className="h-[400px] w-[300px] lg:h-[300px] lg:w-[600px] ">
        <NeshanMapContainer ShowSearch={true} onLocationChange={handleMapClick} />
      </div>

      <Button
        intent="primary"
        fullWidth
        disabled={!location.lat || !location.lng}
        onClick={onFinish}
      >
        ثبت
      </Button>
    </div>
  );
}

export default AddressFormMap;
