import React, { useState } from "react";
import Cookies from "js-cookie";
import { useSnackbar } from "notistack";
import { useAuth } from "@/src/hooks";
import AddressFormMap from "./AddressFormMap";

function AddressPrimary({
  onAddAddress,
  shouldReloadAfterSave = true,
}: {
  onAddAddress: ({ lat, lng }: { lat: string; lng: string }) => void;
  shouldReloadAfterSave?: boolean;
}) {
  const { enqueueSnackbar } = useSnackbar();
  const { getTokenFromCookies } = useAuth();

  const [location, setLocation] = useState({ lat: "", lng: "" });

  // Handle location selection from the map
  const handleAddress = (lat: string, lng: string) => {
    setLocation({ lat, lng });
  };

  const onSubmit = () => {
    const token = getTokenFromCookies();
    console.log("Selected Location:", location);

    if (!location.lat || !location.lng) {
      enqueueSnackbar("لطفاً موقعیت مکانی خود را انتخاب کنید.", {
        variant: "warning",
      });
      return;
    }

    if (token) {
      console.log("Saving location to DB", location);
    } else {
      console.log("User not logged in, saving to localStorage");
      localStorage.setItem("unsavedAddress", JSON.stringify(location));
      Cookies.set("lat", location.lat, { path: "/" });
      Cookies.set("lng", location.lng, { path: "/" });


      if (shouldReloadAfterSave) {
        enqueueSnackbar("موقعیت ذخیره شد و پس از ورود ثبت خواهد شد", {
          variant: "info",
        });
  
        setTimeout(() => {
          window.location.reload();
        }, 1000);
      }

      onAddAddress({lat:location.lat,lng:location.lng});
    }
  };

  return (
    <div className="flex flex-col">
      <AddressFormMap onClick={handleAddress} onFinish={onSubmit} />
    </div>
  );
}

export default AddressPrimary;
