import { FavoritesMenuItems } from "@/src/constants/MenuItems";
import { FavoriteType } from "@/src/types/Favorite";

import React from "react";
import { twMerge } from "tailwind-merge";

interface Props {
  activeTap: FavoriteType;
  onItemClick: (id: FavoriteType) => void;
}
function OrderHeader({ activeTap, onItemClick }: Props) {
  return (
    <div className="border-b border-gray-200 text-center text-h4 text-white ">
      <ul className="-mb-px flex flex-wrap">
        {FavoritesMenuItems.map((item) => (
          <li className="me-1" key={item.id}>
            <button
              onClick={() => onItemClick(item.id)}
              className={twMerge(
                "inline-block rounded-t-3  p-2  hover:text-gray-600 ",
                activeTap === item.id ? "border-b-4 border-secondary" : ""
              )}
            >
              {item.title}
            </button>
          </li>
        ))}
      </ul>
    </div>
  );
}

export default OrderHeader;
