import LoaderSpinner from "@/src/components/LoaderSpinner";
import { useFavoriteChefsQuery } from "@/src/hooks/Queries";
import React from "react";
import { useFavorite } from "@/src/hooks";
import FavoriteChefCard from "./FavoriteChefCard";
import EmptyList from "../../EmptyList";

function FavoriteChefs() {
  const { data, isLoading: ChefsLoading, refetch } = useFavoriteChefsQuery();
  const { removeFavorite, isLoading } = useFavorite();
  return (
    <div className="grid w-full grid-cols-1 gap-2 lg:grid-cols-2">
      {ChefsLoading && <LoaderSpinner />}
      {data &&
        data.map((item) => (
          <FavoriteChefCard
            id={item.data.id}
            isLoading={isLoading}
            ariaTitle={item.data.ariaTitle ?? ""}
            logo={item.data.logo ?? ""}
            onDelete={async () => {
              await removeFavorite("chef", item.data.id);
              refetch();
            }}
            title={item.data.title}
            key={item.id}
          />
        ))}
      {!ChefsLoading && !data?.length && <EmptyList />}
    </div>
  );
}

export default FavoriteChefs;
