import React from "react";
import { useFavoriteFoodsQuery } from "@/src/hooks/Queries";
import { useFavorite } from "@/src/hooks";
import LoaderSpinner from "@/src/components/LoaderSpinner";
import FavoriteProductsCard from "./FavoriteProductsCard";
import EmptyList from "../../EmptyList";

function FavoriteProducts() {
  const { data, isLoading: foodsLoading, refetch } = useFavoriteFoodsQuery();
  const { removeFavorite, isLoading } = useFavorite();
  return (
    <div className="grid w-full grid-cols-1 items-center gap-2 lg:grid-cols-2">
      {foodsLoading && <LoaderSpinner />}

      {data &&
        data.map((item) => (
          <FavoriteProductsCard
            id={item.data.id}
            isLoading={isLoading}
            description={item.data.Summary}
            image={item.data.image}
            title={item.data.title}
            calory={item.data.calory}
            key={item.id}
            onDelete={async () => {
              await removeFavorite("product", item.data.id);
              refetch();
            }}
          />
        ))}
      {!foodsLoading && !data?.length && <EmptyList />}
    </div>
  );
}

export default FavoriteProducts;
