import React, { useCallback } from "react";
import { FavoriteType } from "@/src/types/Favorite";
import FavoriteChefs from "./FavoriteChefs";
import FavoriteProducts from "./FavoriteProducts";

interface Props {
  activeTab: FavoriteType;
}
function FavoriteTabs({ activeTab }: Props) {
  const ActiveTab = useCallback(() => {
    switch (activeTab) {
      case "chef":
        return <FavoriteChefs />;
      case "product":
        return <FavoriteProducts />;

      default:
        return <FavoriteProducts />;
    }
  }, [activeTab]);
  return (
    <div className="flex w-full p-2">
      <ActiveTab />
    </div>
  );
}

export default FavoriteTabs;
