import { FormProvider, TextField } from "@/src/components/RHF";
import React, { useMemo } from "react";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as Yup from "yup";
import Button from "@/src/components/Button";

import { useSnackbar } from "notistack";
// import { numberToWords } from "@persian-tools/persian-tools";
import { useAuth } from "@/src/hooks";

interface FormFields {
  amount: number;
}

const defaultValues: FormFields = {
  amount: 5000,
};

function WalletForm() {
  const addressSchema = useMemo(
    () =>
      Yup.object().shape({
        amount: Yup.number()
          .min(5000, "حداقل مبلغ 5 هزار تومان است")
          .required("لطفا مبلغ را وارد نمایید "),
      }),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []
  );

  const methods = useForm<FormFields>({
    defaultValues,
    resolver: yupResolver(addressSchema),
    mode: "onChange",
  });

  const {
    handleSubmit,
    formState: { isValid, isSubmitting },
    reset,
    // watch,
  } = methods;
  // const amount = watch("amount");
  const { enqueueSnackbar } = useSnackbar();
  const { chargeUserWallet } = useAuth();
  const onSubmit = handleSubmit(async (values) => {
    try {
      const paymentCode = await chargeUserWallet(values.amount);
      window.location.href = `${process.env.NEXT_PUBLIC_DOMAIN}/charge/wallet?code_pay=${paymentCode}`;
      reset();
    } catch (error) {
      console.log(error);
      enqueueSnackbar(" خطا در اتصال به درگاه پرداخت", {
        variant: "error",
      });
    }
  });

  return (
    <div className="flex  flex-col  lg:px-16">
      <FormProvider methods={methods} onSubmit={onSubmit}>
        <div className=" flex w-full flex-col gap-12 ">
          <p className="text-h4 ">
            مبلغ مورد نظر را جهت افزایش موجودی وارد کنید.
          </p>
          <div className="w-full">
            <TextField
              type="number"
              min={5000}
              className="w-full text-left"
              placeholder="مبلغ را وارد کنید ..."
              name="amount"
              WrapperClassName="w-full max-w-full"
            />
            {/* <span className="text-small">
              {numberToWords(amount).toString()} تومان
            </span> */}
          </div>
          <Button type="submit" isLoading={isSubmitting} disabled={!isValid}>
            افزایش موجودی کیف پول
          </Button>
        </div>
      </FormProvider>
    </div>
  );
}

export default WalletForm;
