import { ProfileItems } from "@/src/types/general";
import React, { useCallback } from "react";
import { ArrowRight2 } from "iconsax-react";
import { ProfileMenuItems } from "@/src/constants/MenuItems";
import Info from "./Info";
import Address from "./Address";
import Order from "./Order";
import Favorites from "./Favorites";
import Tickets from "./Tickets";
import Transactions from "./Transactions";
import Discounts from "./Discounts";

import Wallet from "./Wallet";

interface Props {
  activeMenu: ProfileItems;
  onBack: VoidFunction;
}
function ProfileTabs({ activeMenu, onBack }: Props) {
  const ActiveTab = useCallback(() => {
    switch (activeMenu) {
      case "info":
        return <Info />;
      case "wallet":
        return <Wallet />;
      case "address":
        return <Address />;
      case "order":
        return <Order />;
      case "favorites":
        return <Favorites />;
      case "tickets":
        return <Tickets />;
      case "transactions":
        return <Transactions />;
      case "discounts":
        return <Discounts />;

      default:
        return <Info />;
    }
  }, [activeMenu]);
  return (
    <div
      className={`${activeMenu ? "flex" : "hidden"} w-full flex-col gap-4 lg:flex `}
    >
      <div className="flex items-center  justify-start gap-2   py-8 text-h3 font-bold lg:hidden">
        <button onClick={onBack} className="flex   items-center gap-2">
          <ArrowRight2 />

          {activeMenu === "wallet"
            ? "کیف پول"
            : ProfileMenuItems.find((item) => item.id === activeMenu)?.title ??
              ""}
        </button>
      </div>
      <div className="w-full max-w-2xl flex-col rounded-base border border-text-secondary bg-white  p-12  lg:flex">
        <ActiveTab />
      </div>
    </div>
  );
}

export default ProfileTabs;
