import { ProfileMenuItems } from "@/src/constants/MenuItems";
import { useAuth } from "@/src/hooks";
import { LoginCurve, Wallet1 } from "iconsax-react";
import { useRouter } from "next/navigation";
import React from "react";
import { ProfileItems } from "@/src/types/general";
import { useAuthStore, useCartStore } from "@/src/store";
import { numberWithCommas } from "@/src/utils/Helpers";
import { useUserWalletQuery } from "@/src/hooks/Queries";

import SidebarItem from "./SidebarItem";

// import InviteCode from "./InviteCode";

interface Props {
  onItemClick: (id: ProfileItems) => void;
  activeMenu: ProfileItems;
}
function Sidebar({ onItemClick, activeMenu }: Props) {
  const router = useRouter();
  const { authUser } = useAuthStore();
  const { setSynced, resetCard } = useCartStore();
  const { logoutUser } = useAuth();
  const { data } = useUserWalletQuery();
  const handleLogout = () => {
    logoutUser();
    setSynced(false);
    resetCard();
    router.replace("/");
    localStorage.removeItem("selectedAddressId");
    localStorage.removeItem("selectedDeliveryId");
    localStorage.removeItem("deliveryTime");
    localStorage.removeItem("selectedAddress");
    localStorage.removeItem("selectedDelivery");
    localStorage.removeItem("restaurant-selections.v1");
  };

  return (
    <div
      className={` ${
        activeMenu && "hidden"
      } size-full flex-col rounded-base border border-text-secondary bg-white p-12     lg:flex lg:h-max lg:max-w-sm`}
    >
      <div className="  flex flex-col gap-px border-b border-black/20 p-2">
        <p className="text-h2 ">{`${authUser.name} ${authUser.family}`}</p>
        <p className="text-h4 text-black/60">{authUser.mobile}</p>
      </div>

      <ul>
        <SidebarItem
          isActive={activeMenu === "wallet"}
          icon={<Wallet1 />}
          onClick={() => onItemClick("wallet")}
          title="کیف پول"
          description={`${numberWithCommas(data ?? 0)} تومان`}
        />
        {/* <SidebarItem
          isActive={false}
          icon={<Gift />}
          onClick={() =>
            setShowModal((prevState) => ({
              ...prevState,
              invite: true,
            }))
          }
          title="دعوت دوستان"
        /> */}
        {ProfileMenuItems.map((item) => (
          <SidebarItem
            isActive={activeMenu === item.id}
            key={item.id}
            icon={item.icon}
            onClick={() => onItemClick(item.id)}
            title={item.title}
          />
        ))}
        <SidebarItem
          isActive={false}
          icon={<LoginCurve />}
          onClick={handleLogout}
          title="خروج"
          showBorder={false}
        />
      </ul>

      {/* <Modal
        open={showModal.invite}
        title="کد معرف"
        onClose={() =>
          setShowModal((prevState) => ({
            ...prevState,
            invite: false,
          }))
        }
      >
        <InviteCode code={authUser.inviteCode ?? ""} />
      </Modal> */}
    </div>
  );
}

export default Sidebar;
