import Rate from "@/src/components/Rate";
import { ProductComment } from "@/src/types/Comment";
import moment from "jalali-moment";
import React from "react";

interface Props {
  content: string;
  rate: number;
  products: ProductComment[];
  date?: Date;
}
function ChefCommentCard({ content, products, rate, date }: Props) {
  const commentDate = date && moment(date).isValid() 
    ? moment(date).locale("fa").format("D MMM")
    : "";

  return (
    <div className=" min-h-62 w-full border-b border-l border-black/20 p-2">
      <div className="flex justify-between ">
        <div className="flex gap-1">
          {commentDate && <p className="text-h5">{commentDate}</p>}
          <p className=" flex items-center  text-h5">
            {commentDate && (
              <span
                className=" mx-1 inline-flex size-1 items-center
   justify-center rounded-[50%] bg-secondary 
     font-bold "
              ></span>
            )}
            کاربر
          </p>
        </div>
        <div className="flex items-center gap-6 ">
          <Rate count={rate} size={16} />
        </div>
      </div>
      <div>
        <p className="mt-8 text-h3">{content}</p>
      </div>
      <div className="mt-8 flex flex-wrap items-center gap-1">
        {products.map(
          (item) =>
            item.title && (
              <span
                key={item.variety_id}
                className="rounded-half border border-black/30 bg-black/5 p-4 text-h5 text-black"
              >
                {item.title}
              </span>
            )
        )}
      </div>
    </div>
  );
}

export default ChefCommentCard;
