import React from "react";

import { ChefDetail } from "@/src/types/Chef";

import { useChefTimeQuery } from "@/src/hooks/Queries";
import LoaderSpinner from "@/src/components/LoaderSpinner";
import dynamic from "next/dynamic";
import SingleRestaurantTimes from "../SingleRestaurantTimes";
import SingleRestaurantGallery from "../SingleRestaurantGallery";

const StaticMap = dynamic(
  () => import("@/src/components/NeshanMapContainer/StaticNeshanMap"),
  { ssr: false }
);

interface Props {
  chefData: ChefDetail;
}
function SingleRestaurantDescription({ chefData }: Props) {
  const { data, isLoading } = useChefTimeQuery(chefData.id);
  return (
    <div
      id="description"
      className="  flex w-full flex-col gap-8 py-8 lg:gap-20 lg:py-16"
    >
      <p className=" text-h3 ">{chefData.description}</p>
      <div className="flex flex-col gap-20 ">
        <SingleRestaurantGallery chefID={chefData.id} />
        <div className="relative ">
          {!isLoading ? (
            <SingleRestaurantTimes data={data} chefData={chefData} />
          ) : (
            <LoaderSpinner />
          )}
          <div className=" h-[700px] w-full  ">
            <StaticMap
              center={[+chefData.lat, +chefData.lng]}
              marker={[+chefData.lat, +chefData.lng]}
            />
          </div>
        </div>
      </div>
    </div>
  );
}

export default SingleRestaurantDescription;
