import React from "react";
import { ChefDetail } from "@/src/types/Chef";

import SingleRestaurantDescription from "./SingleRestaurantDescription";
import SingleRestaurantComments from "./SingleRestaurantComments";

interface Props {
  chefData: ChefDetail;
}
function SingleRestaurantInfo({ chefData }: Props) {
  return (
    <div className="container">
      <SingleRestaurantDescription chefData={chefData} />
      <SingleRestaurantComments chefID={chefData.id} />
    </div>
  );
}

export default SingleRestaurantInfo;
