/* eslint-disable @typescript-eslint/no-unused-vars */
/* eslint-disable no-unused-vars */
import {
  useCategoriesFoodsQuery,
  usePaginatedFoodsQuery,
} from "@/src/hooks/Queries";
import React, { useEffect, useMemo, useState } from "react";
import { parseAsString, useQueryStates } from "next-usequerystate";
import { OrderDataVariant } from "@/src/types/general";
import { useScrollspy } from "@/src/hooks";
import CategorySlider from "./CategorySlider";
import SingleRestaurantMenuItems from "./SingleRestaurantMenuItems";
import {
  DeliveryDetails,
  DeliveryMethod,
} from "@/src/hooks/Queries/useDeliveryMethodByTime";
import { Accordion } from "@/src/components/Share/Accordion";
import {
  convertEnglishWeekdayToPersian,
  getWithExpiryLocalStorage,
} from "@/src/utils/Helpers";
import { ServiceDetails } from "@/src/services/httpServices/CartServices/types";
import { useAuthStore } from "@/src/store";
import useAreaManagementAddressQuery from "@/src/hooks/Queries/UseAreaManagementAddressQuery";
import RestaurantAccordion from "@/src/components/RestaurantAccordion";
import { useRestaurantSelection } from "@/src/containers/useRestaurantSelection";
import { useSelectionStore } from "@/src/store/useSelectionStore";

interface Props {
  chefID: string;
  available: boolean;
  setAvailableModal?: React.Dispatch<React.SetStateAction<boolean>>;
  deliveryMethod?: DeliveryDetails | undefined;
  deliveryOptions?: DeliveryMethod[];
  areaAddressData?: ServiceDetails | undefined;
  /** When the category slider is rendered outside (e.g. in Tabs), hide it here */
  hideCategorySlider?: boolean;
  /** When parent already provides container, disable internal container wrapper */
  disableContainer?: boolean;
}
function SingleRestaurantMenu({
  chefID,
  available,
  setAvailableModal,
  deliveryMethod,
  deliveryOptions,
  hideCategorySlider,
  disableContainer,
}: Props) {
  const [queryFilters, setQueryFilters] = useQueryStates({
    time: parseAsString.withDefault(""),
    day: parseAsString.withDefault(""),
    searchText: parseAsString.withDefault(""),
  });

  const [deliveryTime, setDeliveryTime] = useState<any>(null);
  const { selectedDeliveryId } = useRestaurantSelection(chefID);

  const { data, isLoading } = useCategoriesFoodsQuery({
    chefID,
    title: queryFilters.searchText,
    time: queryFilters.time,
    day: queryFilters.day,
  });
  const { data: discountFoods, isLoading: discountLoading } =
    usePaginatedFoodsQuery({
      hasDiscount: true,
      order: OrderDataVariant.DESC,
      prePage: 12,
      chefID,
      title: queryFilters.searchText,
    });
  const loading = useMemo(
    () => isLoading || discountLoading,
    [discountLoading, isLoading]
  );
  const ids = useMemo(
    () => data?.map((item) => `item_${item.id}`) ?? [],
    [data]
  );
  const activeId = useScrollspy(ids, 400);

  useEffect(() => {
    if (typeof window !== "undefined") {
      const time = getWithExpiryLocalStorage("deliveryTime");
      setDeliveryTime(time);
    }
  }, [deliveryOptions]);

  const deliveryType = deliveryOptions?.find(
    (item) => Number(item.id) === Number(selectedDeliveryId)
  );
  const { getSelection } = useSelectionStore();

  const { authUser } = useAuthStore();
  const selectedFromStore = getSelection(chefID)?.selectedAddressId;
  const selectedAddressId = selectedFromStore ?? authUser.defaultAddress;

  const {
    data: areaAddressData,
    error,
    isSuccess: areaAddressIsSuccess,
    isLoading: isLoadingqqq,
  } = useAreaManagementAddressQuery({
    branchId: chefID,
    addressId: selectedAddressId,
  });

  return (
    <>
      {!hideCategorySlider && data && (
        <CategorySlider
          activeId={activeId}
          data={data}
          wrapperClassName="lg:container py-20 pr-12 sticky lg:top-0 top-20"
        />
      )}

      {setAvailableModal ? (
        <div className="mb-10 max-w-sm px-10 lg:hidden  ">
          <RestaurantAccordion
            chefId={chefID}
            areaAddressData={areaAddressData}
            setAvailableModal={setAvailableModal}
            deliveryType={deliveryType}
          />
        </div>
      ) : (
        ""
      )}

      <div className={disableContainer ? "relative" : "container relative"}>
        <SingleRestaurantMenuItems
          isLoading={loading}
          foods={data}
          discountFoods={discountFoods?.data ?? []}
          available={available}
        />
      </div>
    </>
  );
}

export default SingleRestaurantMenu;
