import { createUrl } from "@/src/utils/Helpers";
import { usePathname, useRouter, useSearchParams } from "next/navigation";

function UseUrlStore() {
  const searchParam = useSearchParams();
  const router = useRouter();
  const BasePathname = usePathname();

  const setData = (
    key: string,
    data: string,
    pathname: string = BasePathname
  ) => {
    const newParams = new URLSearchParams(searchParam.toString());
    if (data) newParams.set(key, data);
    else newParams.delete(key);
    router.replace(createUrl(pathname, newParams));
  };

  const deleteData = (key: string, pathname: string = BasePathname) => {
    const params = new URLSearchParams(searchParam.toString());
    params.delete(key);

    router.replace(createUrl(pathname, params));
  };

  const getData = (key: string) => {
    const params = new URLSearchParams(searchParam.toString());
    return params.get(key);
  };
  const getKeys = () => {
    const params = new URLSearchParams(searchParam.toString());
    return params.entries();
  };
  const getAllData = () => {
    const params = new URLSearchParams(searchParam.toString());
    const allData = Object.fromEntries(params);
    return allData;
  };
  const reset = (
    resetData?: {
      [index: string]: string;
    },
    pathname: string = BasePathname
  ) => {
    if (resetData) {
      const newParams = new URLSearchParams(searchParam.toString());
      const newKeys = Object.keys(resetData);

      newKeys.forEach((key) => {
        if (resetData[key]) newParams.set(key, resetData[key]);
        else newParams.delete(key);
      });

      router.replace(createUrl(pathname, newParams));
    } else router.replace(pathname);
  };

  return {
    setData,
    deleteData,
    getData,
    getKeys,
    getAllData,
    reset,
  };
}

export default UseUrlStore;
