import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

function UseChefGalleryQuery(chefID: string) {
  const { getChefGallery } = useChefs();

  const queryData = useQuery({
    queryKey: ["chefGallery", chefID],
    queryFn: () => getChefGallery(chefID),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseChefGalleryQuery;
