import { useQuery } from "@tanstack/react-query";

import { useCart } from "../UseCart";

function UseDeliveryTypesQuery(branchId: string) {
  const { getDeliveryTypes } = useCart();

  const queryKey = ["deliveryTypes", branchId];
  const queryData = useQuery({
    queryKey,
    queryFn: () => getDeliveryTypes(branchId),
    refetchOnWindowFocus: false,
    staleTime: Infinity,
    enabled: !!branchId,

  });

  return queryData;
}

export default UseDeliveryTypesQuery;
