import { useQuery } from "@tanstack/react-query";

import { useCart } from "../UseCart";

function UseGatewayQuery() {
  const { getGateway } = useCart();

  const queryKey = ["getawayList"];
  const queryData = useQuery({
    queryKey,
    staleTime: Infinity,
    queryFn: () => getGateway(),
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseGatewayQuery;
