import { useQuery } from "@tanstack/react-query";
import { useCart } from "../UseCart";

function UseOrderQuery(id?: string) {
  const { getUserOrder } = useCart();

  const queryKey = ["order", id];
  const queryData = useQuery({
    queryKey,
    queryFn: () => getUserOrder(id ?? ""),
    refetchOnWindowFocus: false,
    enabled: !!id,
  });

  return queryData;
}

export default UseOrderQuery;
