import {
  getCategoriesService,
  getPostCategoriesService,
} from "@/src/services/httpServices/CategoryServices";
import { ApiCategory } from "@/src/services/httpServices/CategoryServices/types";
import { Category } from "@/src/types/category";
import { useState } from "react";

function UseCategories() {
  const [isLoading, setIsLoading] = useState(false);

  const getCategories = async (chefID?: string, parentID?: string,lat?:string,lng?:string) => {
    try {
      setIsLoading(true);
      const result = await getCategoriesService({
        ...(lng && {
          lng: lng,
        }),
        ...(lat && {
          lat: lat,
        }),
        ...(chefID && {
          branch_id: chefID,
        }),
        ...(parentID && {
          parent_id: parentID,
        }),
      });
 
      const modeledUser: Category[] = result.map((item : ApiCategory & {child_count?:number}) => ({
        id: item.id,
        title: item.title,
        image: item.img,
        child_count:item.child_count || 0
      }));

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getPostCategories = async () => {
    try {
      setIsLoading(true);
      const result = await getPostCategoriesService();

      const modeledUser: Category[] = result.map((item : ApiCategory & {child_count?:number}) => ({
        id: item.id,
        title: item.title,
        child_count:item.child_count || 0
      }));

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    getCategories,
    getPostCategories,
  };
}

export default UseCategories;
