import { useState } from "react";
import { convertLocalFavoriteToApi } from "@/src/utils/Helpers";
import { FavoriteItem, FavoriteType } from "@/src/types/Favorite";
import { BaseChef } from "@/src/types/Chef";
import { BaseFood } from "@/src/types/food";
import {
  addItemToFavoritesService,
  FavoritesStatusService,
  getFavoritesChefsService,
  getFavoritesProductsService,
  removeItemToFavoritesService,
} from "../../services/httpServices/FavoriteService/index";

function UseFavorite() {
  const [isLoading, setIsLoading] = useState(false);

  const favoriteStatus = async (type: FavoriteType, id: string) => {
    try {
      setIsLoading(true);
      const result = await FavoritesStatusService({
        target_id: id,
        type: convertLocalFavoriteToApi(type),
      });
      return Boolean(result);
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const addFavorite = async (type: FavoriteType, id: string) => {
    try {
      setIsLoading(true);
      await addItemToFavoritesService({
        target_id: id,
        type: convertLocalFavoriteToApi(type),
      });
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const removeFavorite = async (type: FavoriteType, id: string) => {
    try {
      setIsLoading(true);
      await removeItemToFavoritesService({
        target_id: id,
        type: convertLocalFavoriteToApi(type),
      });
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getFavoritesChefs = async () => {
    try {
      setIsLoading(true);
      const result = await getFavoritesChefsService();
      const moddledResponse: FavoriteItem<BaseChef>[] = result.map((item) => ({
        id: item.id,
        type: "chef",
        data: {
          id: item.branch.id,
          title: item.branch.title,
          rate: +item.branch.rate,
          logo: item.branch.logo,
          ariaTitle: item.branch.area?.title ?? "-",
        },
      }));
      return moddledResponse;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getFavoritesFoods = async () => {
    try {
      setIsLoading(true);
      const result = await getFavoritesProductsService();
      const moddledResponse: FavoriteItem<BaseFood>[] = result.map((item) => ({
        id: item.id,
        type: "product",
        data: {
          chefID: item.product.branch_id,
          image: item.product.image,
          id: item.product.id,
          rate: item.product.rate,
          Summary: item.product.description,
          title: item.product.title,
          discount: {
            discountedPrice: 0,
            percent: 0,
          },
          price: 0,
          varietyID: "0",
          calory: item.product.calory,
        },
      }));
      return moddledResponse;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    favoriteStatus,
    addFavorite,
    removeFavorite,
    getFavoritesChefs,
    getFavoritesFoods,
  };
}

export default UseFavorite;
