import { uploadFileService } from "@/src/services/httpServices/UploadServices";
import { ApiUploadFile } from "@/src/services/httpServices/UploadServices/types";
import Cookies from "js-cookie";
import { useState } from "react";

interface Props {
  onUploadComplete?: VoidFunction;
}
function UseUpload({ onUploadComplete }: Props) {
  const [isLoading, setIsLoading] = useState(false);

  const uploadFile = async (data: File, name: string): Promise<string> => {
    try {
      setIsLoading(true);
      const formData = new FormData();
      formData.append("contents", data);
      formData.append("file", data);
      formData.append("filename", name);
      formData.append("name", name);
      const token = Cookies.get("token") || "";
      const uploadPath = await uploadFileService(
        formData as unknown as ApiUploadFile,
        token
      );
      if (onUploadComplete) onUploadComplete();
      return uploadPath || "";
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    uploadFile,
  };
}

export default UseUpload;
