import { useCartStore } from "@/src/store";
import { useMemo } from "react";

export const useCartItemCount = (varietyID: string) => {
  const cardItems = useCartStore((state) => state.cardItems);
  
  const count = useMemo(() => {
    const item = cardItems.find((item) => item.variety.varietyID === varietyID);
    const itemCount = item?.count ?? 0;
    console.log(`useCartItemCount - varietyID: ${varietyID}, count: ${itemCount}, totalItems: ${cardItems.length}`);
    return Math.max(0, Number(itemCount) || 0);
  }, [cardItems, varietyID]);
  
  return count;
};