"use client";

import React, { ReactNode, useEffect } from "react";

import UseCartStore from "../store/UseCartStore";
import { useCartQuery } from "../hooks/Queries";

interface Props {
  children: ReactNode;
}
function CartProvider({ children }: Props) {
  const { addToCard, resetCard, setDelivery } = UseCartStore();

  const {
    queryData: { data },
  } = useCartQuery();

  useEffect(() => {
    resetCard();
    data?.cart.forEach((item) => {
      addToCard({
        count: item.count,
        food: item.food,
        variety: item.variety,
      });
    });
    if (data?.deliveryType) {
      setDelivery(data?.deliveryType);
    }
  }, [data]);
  return <>{children}</>;
}

export default CartProvider;
