import { ApiTimeStampData } from "@/src/types/general";

export interface ApiCreateAddress {
  title: string;
  lat: string;
  lng: string;
  address: string;
  area_id?: string;
  phone_number: string;
}
export interface ApiArea extends ApiTimeStampData {
  id: string;
  title: string;
  slug: string;
  parent_id: number;
  parent: ApiArea;
  lat: string;
  lng: string;
}
export interface ApiAddress extends ApiTimeStampData {
  is_active:boolean;
  id: string;
  user_id: string;
  title: string;
  lat: string;
  lng: string;
  address: string;
  plaque: string;
  postal_code: string;
  phone_number: string;
  unit: string;
  area: ApiArea;
}


export interface ApiAddressResponse extends ApiTimeStampData {
  is_active: boolean;
  id: string;
  user_id: string;
  title: string;
  lat: string;
  lng: string;
  address: string;
  plaque: string;
  postal_code: string;
  phone_number: string;
  unit: string;
  area: ApiArea;
}
export interface ApiAddressByTime  {
  data:ApiAddressResponse[]
  is_location_in_active_area?:boolean
}
