import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiChefPopupAlarm, ApiChefSlider } from "@/src/types/Chef";
import { ApiSitemap } from "@/src/types/general";
import { httpService } from "../httpService";
import {
  ApiAvailableTime,
  ApiAvailableTimeList,
  ApiBranch,
  ApiBranchPreOrder,
  ApiChefGallery,
  ApiChefPaginated,
  ApiChefParams,
  ApiChefRegistration,
} from "./types";

const { chef, slider, vendor } = apiEndpoints;

export const getChefAvailableNowService = (
  chefID: string
): Promise<ApiAvailableTime | null> =>
  httpService.get(`${chef.availableNow}${chefID}`);
export const getChefAvailableTimeService = (
  chefID: string
): Promise<ApiAvailableTimeList> =>
  httpService.get(`${chef.available}${chefID}`);

export const getGalleryService = (
  chefID: string
): Promise<ApiChefGallery[] | []> =>
  httpService.get(`${chef.gallery}${chefID}`);

export const getChefService = (
  chefID: string,
  token?: string
): Promise<ApiBranch> =>
  httpService.get(`${chef.getChef}${chefID}`, {
    ...(token && {
      headers: {
        Authorization: `Bearer ${token}`,
      },
    }),
  });

export const getChefsService = (
  params?: ApiChefParams
): Promise<ApiChefPaginated> => httpService.get(chef.base, { params });

export const getChefSliderService = (params?: {
  branche_id: string;
}): Promise<ApiChefSlider> => httpService.get(slider.base, { params });

export const getChefPopupAlarm = (params?: {
  branch_id: string;
}): Promise<ApiChefPopupAlarm[]> => httpService.get('/popup-alarms/unseen-alarms', { params });

export const ChefRegistrationService = (data: FormData) =>
  httpService.post(vendor.create, data, {
    headers: {
      "Content-Type": "multipart/form-data", // Let Axios set boundary automatically
    },
  });

export const getChefsSitemapService = (): Promise<ApiSitemap> =>
  httpService.get(chef.sitemap);
export const getChefPreOrderTimeService = (
  chefID: string
): Promise<ApiBranchPreOrder> =>
  httpService.get(`${chef.preOrderTime}${chefID}`);
