import { apiEndpoints } from "@/src/constants/Endpoints";
import { httpService } from "../httpService";
import { ApiComment, ApiRate, ApiSetComment } from "./types";

const { comment, cart } = apiEndpoints;

export const getProductCommentsService = (
  productID: string
): Promise<ApiComment[]> =>
  httpService.get(`${comment.productComments}${productID}`);
export const getChefCommentsService = (chefID: string): Promise<ApiComment[]> =>
  httpService.get(`${comment.chefComment}${chefID}`);
export const getChefCommentsRateService = (chefID: string): Promise<ApiRate> =>
  httpService.get(`${comment.branchRate}${chefID}`);
export const sendCommentService = (orderId: string, data: ApiSetComment) =>
  httpService.post(`${cart.setComment}/${orderId}`, data);
