import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiPaginationResult } from "@/src/types/general";
import { httpService } from "../httpService";
import { ApiDiscountItem } from "./types";

const {
  user: { getUserDiscounts },
} = apiEndpoints;

export const getDiscountsService = (params: {
  page: number;
  paginate: number;
}): Promise<ApiPaginationResult<ApiDiscountItem>> =>
  httpService.get(getUserDiscounts, {
    params,
  });
