import axios from "axios";
import { ApiNeshanAddress, ApiNeshanSearch } from "./types";

export const getAddressFromLocationService = (
  lat: string,
  lng: string
): Promise<ApiNeshanAddress> =>
  axios.get(`https://api.neshan.org/v5/reverse?lat=${lat}&lng=${lng}`, {
    headers: {
      "Api-Key": process.env.NEXT_PUBLIC_NESHAN_SERVICE_API_KEY,
    },
  });
export const getLocationFromAddressService = async (
  term: string
): Promise<ApiNeshanSearch> => {
  try {
    const res = await axios.get(`https://api.neshan.org/v1/search?term=${term}&lng=0&lat=0`, {
      headers: {
        "Api-Key": process.env.NEXT_PUBLIC_NESHAN_SERVICE_API_KEY,
      },
    });
    return res.data;
  } catch (err: any) {
    console.error("Neshan search failed:", err.response?.status, err.response?.data);
    throw err; // rethrow so React Query / caller can handle it
  }
};
